/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.timeseries.util;

import java.time.Duration;
import org.opensearch.timeseries.model.Config;
import org.opensearch.timeseries.model.IntervalTimeConfiguration;

public class TimeUtil {
    public static long calculateTimeoutMillis(Config config, long dataEndTimeMillis) {
        long windowDelayMillis = config.getWindowDelay() == null ? 0L : ((IntervalTimeConfiguration)config.getWindowDelay()).toDuration().toMillis();
        long nextExecutionEnd = dataEndTimeMillis + config.getIntervalInMilliseconds() + windowDelayMillis;
        return nextExecutionEnd;
    }

    public static boolean isMultiple(Duration a, Duration b) {
        if (b.isZero()) {
            return a.isZero();
        }
        long aNanos = a.toNanos();
        long bNanos = b.toNanos();
        return bNanos != 0L && aNanos % bNanos == 0L;
    }

    public static long getMultiple(Duration a, Duration b) {
        if (b.isZero()) {
            return 0L;
        }
        long aNanos = a.toNanos();
        long bNanos = b.toNanos();
        return aNanos / bNanos;
    }
}

