/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.core;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public interface ContextPropagator<T> {
    public Supplier<Optional<T>> retrieve();

    public Consumer<Optional<T>> copy();

    public Consumer<Optional<T>> clear();

    public static <T> Supplier<T> decorateSupplier(ContextPropagator propagator, Supplier<T> supplier) {
        Optional value = propagator.retrieve().get();
        return () -> {
            try {
                propagator.copy().accept(value);
                Object t = supplier.get();
                return t;
            }
            finally {
                propagator.clear().accept(value);
            }
        };
    }

    public static <T> Supplier<T> decorateSupplier(List<? extends ContextPropagator> propagators, Supplier<T> supplier) {
        Objects.requireNonNull(propagators, "ContextPropagator list should be non null");
        Map values = propagators.stream().collect(Collectors.toMap(p -> p, p -> p.retrieve().get(), (first, second) -> second, HashMap::new));
        return () -> {
            try {
                values.forEach((p, v) -> p.copy().accept((Optional<Object>)v));
                Object t = supplier.get();
                return t;
            }
            finally {
                values.forEach((p, v) -> p.clear().accept((Optional<Object>)v));
            }
        };
    }

    public static <T> Callable<T> decorateCallable(ContextPropagator propagator, Callable<T> callable) {
        Optional value = propagator.retrieve().get();
        return () -> {
            try {
                propagator.copy().accept(value);
                Object v = callable.call();
                return v;
            }
            finally {
                propagator.clear().accept(value);
            }
        };
    }

    public static <T> Callable<T> decorateCallable(List<? extends ContextPropagator> propagators, Callable<T> callable) {
        Objects.requireNonNull(propagators, "ContextPropagator list should be non null");
        Map values = propagators.stream().collect(Collectors.toMap(p -> p, p -> p.retrieve().get(), (first, second) -> second, HashMap::new));
        return () -> {
            try {
                values.forEach((p, v) -> p.copy().accept((Optional<Object>)v));
                Object v2 = callable.call();
                return v2;
            }
            finally {
                values.forEach((p, v) -> p.clear().accept((Optional<Object>)v));
            }
        };
    }

    public static <T> Runnable decorateRunnable(List<? extends ContextPropagator> propagators, Runnable runnable) {
        Objects.requireNonNull(propagators, "ContextPropagator list should be non null");
        Map values = propagators.stream().collect(Collectors.toMap(p -> p, p -> p.retrieve().get(), (first, second) -> second, HashMap::new));
        return () -> {
            try {
                values.forEach((p, v) -> p.copy().accept((Optional<Object>)v));
                runnable.run();
            }
            finally {
                values.forEach((p, v) -> p.clear().accept((Optional<Object>)v));
            }
        };
    }

    public static <T> Runnable decorateRunnable(ContextPropagator propagator, Runnable runnable) {
        Optional value = propagator.retrieve().get();
        return () -> {
            try {
                propagator.copy().accept(value);
                runnable.run();
            }
            finally {
                propagator.clear().accept(value);
            }
        };
    }

    public static <T> ContextPropagator<T> empty() {
        return new EmptyContextPropagator();
    }

    public static class EmptyContextPropagator<T>
    implements ContextPropagator<T> {
        @Override
        public Supplier<Optional<T>> retrieve() {
            return () -> Optional.empty();
        }

        @Override
        public Consumer<Optional<T>> copy() {
            return t -> {};
        }

        @Override
        public Consumer<Optional<T>> clear() {
            return t -> {};
        }
    }
}

