/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager;

import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.jboss.logmanager.FastCopyHashMap;

final class CopyOnWriteMap<K, V>
extends AbstractMap<K, V>
implements ConcurrentMap<K, V>,
Cloneable {
    private static final FastCopyHashMap EMPTY = new FastCopyHashMap(32, 0.25f);
    private volatile FastCopyHashMap<K, V> map = EMPTY;
    private static final AtomicReferenceFieldUpdater<CopyOnWriteMap, FastCopyHashMap> mapUpdater = AtomicReferenceFieldUpdater.newUpdater(CopyOnWriteMap.class, FastCopyHashMap.class, "map");

    CopyOnWriteMap() {
    }

    @Override
    public V get(Object key) {
        return this.map.get(key);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public void clear() {
        this.map = EMPTY;
    }

    @Override
    public V put(K key, V value) {
        V result;
        Object newVal;
        FastCopyHashMap<K, V> oldVal;
        do {
            oldVal = this.map;
            newVal = oldVal.clone();
            result = ((FastCopyHashMap)newVal).put(key, value);
        } while (!mapUpdater.compareAndSet(this, oldVal, (FastCopyHashMap)newVal));
        return result;
    }

    @Override
    public V remove(Object key) {
        Object result;
        Object newVal;
        FastCopyHashMap<K, V> oldVal;
        do {
            if (!(oldVal = this.map).containsKey(key)) {
                return null;
            }
            newVal = oldVal.clone();
            result = ((FastCopyHashMap)newVal).remove(key);
        } while (!mapUpdater.compareAndSet(this, oldVal, (FastCopyHashMap)newVal));
        return result;
    }

    @Override
    public CopyOnWriteMap<K, V> clone() {
        try {
            return (CopyOnWriteMap)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException();
        }
    }

    @Override
    public V putIfAbsent(K key, V value) {
        Object newVal;
        FastCopyHashMap<K, V> oldVal;
        do {
            if ((oldVal = this.map).containsKey(key)) {
                return oldVal.get(key);
            }
            newVal = oldVal.clone();
            ((FastCopyHashMap)newVal).put(key, value);
        } while (!mapUpdater.compareAndSet(this, oldVal, (FastCopyHashMap)newVal));
        return null;
    }

    @Override
    public boolean remove(Object key, Object value) {
        Object newVal;
        FastCopyHashMap<K, V> oldVal;
        do {
            if (value == (oldVal = this.map).get(key) && (value != null || oldVal.containsKey(key))) {
                if (oldVal.size() == 1) {
                    newVal = EMPTY;
                    continue;
                }
                newVal = oldVal.clone();
                ((FastCopyHashMap)newVal).remove(key);
                continue;
            }
            return false;
        } while (!mapUpdater.compareAndSet(this, oldVal, (FastCopyHashMap)newVal));
        return true;
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        Object newVal;
        FastCopyHashMap<K, V> oldVal;
        do {
            if (oldValue != (oldVal = this.map).get(key) || oldValue == null && !oldVal.containsKey(key)) {
                return false;
            }
            newVal = oldVal.clone();
            ((FastCopyHashMap)newVal).put(key, newValue);
        } while (!mapUpdater.compareAndSet(this, oldVal, (FastCopyHashMap)newVal));
        return true;
    }

    @Override
    public V replace(K key, V value) {
        V result;
        Object newVal;
        FastCopyHashMap<K, V> oldVal;
        do {
            if (value != (oldVal = this.map).get(key) || value == null && !oldVal.containsKey(key)) {
                return null;
            }
            newVal = oldVal.clone();
            result = ((FastCopyHashMap)newVal).put(key, value);
        } while (!mapUpdater.compareAndSet(this, oldVal, (FastCopyHashMap)newVal));
        return result;
    }

    @Override
    public Set<K> keySet() {
        return Collections.unmodifiableSet(this.map.keySet());
    }

    @Override
    public Collection<V> values() {
        return Collections.unmodifiableCollection(this.map.values());
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return Collections.unmodifiableSet(this.map.entrySet());
    }
}

