/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime.security;

import io.netty.handler.codec.http.HttpResponseStatus;
import io.quarkus.arc.ClientProxy;
import io.quarkus.security.AuthenticationFailedException;
import io.quarkus.security.identity.IdentityProvider;
import io.quarkus.security.identity.IdentityProviderManager;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.identity.request.AnonymousAuthenticationRequest;
import io.quarkus.security.identity.request.AuthenticationRequest;
import io.quarkus.security.spi.runtime.AuthenticationFailureEvent;
import io.quarkus.security.spi.runtime.AuthenticationSuccessEvent;
import io.quarkus.security.spi.runtime.SecurityEvent;
import io.quarkus.security.spi.runtime.SecurityEventHelper;
import io.quarkus.vertx.http.runtime.AuthRuntimeConfig;
import io.quarkus.vertx.http.runtime.VertxHttpConfig;
import io.quarkus.vertx.http.runtime.security.AbstractPathMatchingHttpSecurityPolicy;
import io.quarkus.vertx.http.runtime.security.ChallengeData;
import io.quarkus.vertx.http.runtime.security.HttpAuthenticationMechanism;
import io.quarkus.vertx.http.runtime.security.HttpCredentialTransport;
import io.quarkus.vertx.http.runtime.security.HttpSecurityConfiguration;
import io.quarkus.vertx.http.runtime.security.HttpSecurityUtils;
import io.quarkus.vertx.http.runtime.security.RoutingContextAwareSecurityIdentity;
import io.smallrye.mutiny.Uni;
import io.vertx.ext.web.RoutingContext;
import jakarta.enterprise.event.Event;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.inject.Singleton;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.jboss.logging.Logger;

@Singleton
public final class HttpAuthenticator {
    public static final String TEST_IF_BASIC_AUTH_IMPLICITLY_REQUIRED = "io.quarkus.security.http.test-if-basic-auth-implicitly-required";
    public static final String BASIC_AUTH_ANNOTATION_DETECTED = "io.quarkus.security.http.basic-authentication-annotation-detected";
    private static final Logger LOG = Logger.getLogger(HttpAuthenticator.class);
    private static final String AUTH_MECHANISM = HttpAuthenticator.class.getName() + "#auth-mechanism";
    private static final String ATTEMPT_AUTH_INVOKED = HttpAuthenticator.class.getName() + "#attemptAuthentication";
    private static boolean selectAuthMechanismWithAnnotation = false;
    private final IdentityProviderManager identityProviderManager;
    private final HttpAuthenticationMechanism[] mechanisms;
    private final SecurityEventHelper<AuthenticationSuccessEvent, AuthenticationFailureEvent> securityEventHelper;
    private final boolean inclusiveAuth;
    private final boolean strictInclusiveMode;

    HttpAuthenticator(IdentityProviderManager identityProviderManager, Event<AuthenticationFailureEvent> authFailureEvent, Event<AuthenticationSuccessEvent> authSuccessEvent, BeanManager beanManager, VertxHttpConfig httpConfig, Instance<IdentityProvider<?>> providers, @ConfigProperty(name="quarkus.security.events.enabled") boolean securityEventsEnabled) {
        this.securityEventHelper = new SecurityEventHelper(authSuccessEvent, authFailureEvent, (SecurityEvent)SecurityEventHelper.AUTHENTICATION_SUCCESS, (SecurityEvent)SecurityEventHelper.AUTHENTICATION_FAILURE, beanManager, securityEventsEnabled);
        this.identityProviderManager = identityProviderManager;
        this.inclusiveAuth = httpConfig.auth().inclusive();
        this.strictInclusiveMode = httpConfig.auth().inclusiveMode() == AuthRuntimeConfig.InclusiveMode.STRICT;
        this.mechanisms = HttpSecurityConfiguration.get().getMechanisms(providers, this.inclusiveAuth);
    }

    public IdentityProviderManager getIdentityProviderManager() {
        return this.identityProviderManager;
    }

    public Uni<SecurityIdentity> attemptAuthentication(final RoutingContext routingContext) {
        AbstractPathMatchingHttpSecurityPolicy pathMatchingPolicy;
        if (selectAuthMechanismWithAnnotation) {
            HttpAuthenticator.rememberAuthAttempted(routingContext);
        }
        HttpSecurityConfiguration.AuthenticationMechanism pathSpecificMechanism = selectAuthMechanismWithAnnotation && HttpAuthenticator.isAuthMechanismSelected(routingContext) ? HttpAuthenticator.getAuthMechanism(routingContext) : ((pathMatchingPolicy = (AbstractPathMatchingHttpSecurityPolicy)routingContext.get(AbstractPathMatchingHttpSecurityPolicy.class.getName())) != null ? pathMatchingPolicy.getAuthMechanism(routingContext) : null);
        Uni result = pathSpecificMechanism == null ? this.createSecurityIdentity(routingContext, 0) : this.findBestCandidateMechanism(routingContext, pathSpecificMechanism).onItem().ifNotNull().transformToUni((Function)new Function<HttpAuthenticationMechanism, Uni<? extends SecurityIdentity>>(){

            @Override
            public Uni<SecurityIdentity> apply(HttpAuthenticationMechanism mech) {
                return mech.authenticate(routingContext, HttpAuthenticator.this.identityProviderManager);
            }
        });
        if (this.inclusiveAuth && this.strictInclusiveMode && pathSpecificMechanism == null) {
            result = result.onItem().ifNotNull().transformToUni((Function)new Function<SecurityIdentity, Uni<? extends SecurityIdentity>>(){

                @Override
                public Uni<? extends SecurityIdentity> apply(SecurityIdentity identity) {
                    Map<String, SecurityIdentity> identities = HttpSecurityUtils.getSecurityIdentities(routingContext);
                    if (identities == null || identities.size() != HttpAuthenticator.this.mechanisms.length) {
                        return Uni.createFrom().failure((Throwable)new AuthenticationFailedException("There is '%d' HTTP authentication mechanisms, however only '%d' authentication mechanisms\ncreated identity: %s\n".formatted(identities == null ? 0 : identities.size(), HttpAuthenticator.this.mechanisms.length, identities == null ? "" : identities.keySet())));
                    }
                    return Uni.createFrom().item((Object)identity);
                }
            });
        }
        if (routingContext.get("io.quarkus.vertx.http.runtime.security.RolesMapping") != null) {
            result = result.onItem().ifNotNull().transform((Function)routingContext.get("io.quarkus.vertx.http.runtime.security.RolesMapping"));
        }
        if (this.securityEventHelper.fireEventOnFailure()) {
            result = result.onFailure().invoke((Consumer)new Consumer<Throwable>(){

                @Override
                public void accept(Throwable throwable) {
                    HttpAuthenticator.this.securityEventHelper.fireFailureEvent((SecurityEvent)new AuthenticationFailureEvent(throwable, Map.of(RoutingContext.class.getName(), routingContext)));
                }
            });
        }
        if (this.securityEventHelper.fireEventOnSuccess()) {
            result = result.onItem().ifNotNull().invoke((Consumer)new Consumer<SecurityIdentity>(){

                @Override
                public void accept(SecurityIdentity securityIdentity) {
                    HttpAuthenticator.this.securityEventHelper.fireSuccessEvent((SecurityEvent)new AuthenticationSuccessEvent(securityIdentity, Map.of(RoutingContext.class.getName(), routingContext)));
                }
            });
        }
        return result;
    }

    private Uni<SecurityIdentity> createSecurityIdentity(final RoutingContext routingContext, final int i) {
        if (i == this.mechanisms.length) {
            return Uni.createFrom().nullItem();
        }
        return this.mechanisms[i].authenticate(routingContext, this.identityProviderManager).onItem().transformToUni((Function)new Function<SecurityIdentity, Uni<? extends SecurityIdentity>>(){

            @Override
            public Uni<SecurityIdentity> apply(SecurityIdentity identity) {
                if (identity != null) {
                    if (HttpAuthenticator.this.inclusiveAuth) {
                        return HttpAuthenticator.this.authenticateWithAllMechanisms(identity, i, routingContext);
                    }
                    if (selectAuthMechanismWithAnnotation && !HttpAuthenticator.isAuthMechanismSelected(routingContext)) {
                        return HttpAuthenticator.rememberAuthMechScheme(HttpAuthenticator.this.mechanisms[i], routingContext).replaceWith((Object)identity);
                    }
                    return Uni.createFrom().item((Object)identity);
                }
                return HttpAuthenticator.this.createSecurityIdentity(routingContext, i + 1);
            }
        });
    }

    public Uni<Boolean> sendChallenge(final RoutingContext routingContext) {
        HttpAuthenticationMechanism matchingMech;
        if (!routingContext.request().isEnded()) {
            routingContext.request().resume();
        }
        Uni result = null;
        if (this.mechanisms.length > 1 && (matchingMech = (HttpAuthenticationMechanism)routingContext.get(HttpAuthenticationMechanism.class.getName())) != null) {
            result = matchingMech.sendChallenge(routingContext);
        }
        if (result == null) {
            result = this.mechanisms[0].sendChallenge(routingContext);
            for (int i = 1; i < this.mechanisms.length; ++i) {
                final HttpAuthenticationMechanism mech = this.mechanisms[i];
                result = result.onItem().transformToUni((Function)new Function<Boolean, Uni<? extends Boolean>>(){

                    @Override
                    public Uni<? extends Boolean> apply(Boolean authDone) {
                        if (authDone.booleanValue()) {
                            return Uni.createFrom().item((Object)authDone);
                        }
                        return mech.sendChallenge(routingContext);
                    }
                });
            }
        }
        return result.onItem().transformToUni((Function)new Function<Boolean, Uni<? extends Boolean>>(){

            @Override
            public Uni<? extends Boolean> apply(Boolean authDone) {
                if (!authDone.booleanValue()) {
                    LOG.debug((Object)"Authentication has not been done, returning HTTP status 401");
                    routingContext.response().setStatusCode(401);
                    if (routingContext.get("io.quarkus.vertx.http.runtime.security.dev-mode.auth-failure-body") == null) {
                        routingContext.response().end();
                    } else {
                        String authenticationFailureBody = (String)routingContext.get("io.quarkus.vertx.http.runtime.security.dev-mode.auth-failure-body");
                        routingContext.response().end(authenticationFailureBody);
                    }
                }
                return Uni.createFrom().item((Object)authDone);
            }
        });
    }

    public Uni<ChallengeData> getChallenge(final RoutingContext routingContext) {
        HttpAuthenticationMechanism matchingMech;
        if (this.mechanisms.length > 1 && (matchingMech = (HttpAuthenticationMechanism)routingContext.get(HttpAuthenticationMechanism.class.getName())) != null) {
            return matchingMech.getChallenge(routingContext);
        }
        Uni result = this.mechanisms[0].getChallenge(routingContext);
        for (int i = 1; i < this.mechanisms.length; ++i) {
            final HttpAuthenticationMechanism mech = this.mechanisms[i];
            result = result.onItem().transformToUni((Function)new Function<ChallengeData, Uni<? extends ChallengeData>>(){

                @Override
                public Uni<? extends ChallengeData> apply(ChallengeData data) {
                    if (data != null) {
                        return Uni.createFrom().item((Object)data);
                    }
                    return mech.getChallenge(routingContext);
                }
            });
        }
        return result;
    }

    private Uni<SecurityIdentity> authenticateWithAllMechanisms(final SecurityIdentity identity, final int i, final RoutingContext routingContext) {
        return this.mechanisms[i].getCredentialTransport(routingContext).onItem().transformToUni((Function)new Function<HttpCredentialTransport, Uni<? extends SecurityIdentity>>(){

            @Override
            public Uni<SecurityIdentity> apply(HttpCredentialTransport httpCredentialTransport) {
                boolean isFirstIdentity;
                if (httpCredentialTransport == null || httpCredentialTransport.getAuthenticationScheme() == null) {
                    LOG.error((Object)"Illegal state - HttpAuthenticationMechanism '%s' authentication scheme is not available.\nThe authentication scheme is required when inclusive authentication is enabled.\n".formatted(((HttpAuthenticationMechanism)ClientProxy.unwrap((Object)HttpAuthenticator.this.mechanisms[i])).getClass().getName()));
                    return Uni.createFrom().failure((Throwable)new AuthenticationFailedException());
                }
                String authMechanism = httpCredentialTransport.getAuthenticationScheme();
                Map<String, SecurityIdentity> authMechToIdentity = HttpSecurityUtils.getSecurityIdentities(routingContext);
                boolean bl = isFirstIdentity = authMechToIdentity == null;
                if (isFirstIdentity) {
                    authMechToIdentity = new HashMap<String, SecurityIdentity>();
                    routingContext.put("io.quarkus.security.identities", authMechToIdentity);
                }
                authMechToIdentity.putIfAbsent(authMechanism, identity);
                if (isFirstIdentity) {
                    return HttpAuthenticator.this.createSecurityIdentity(routingContext, i + 1).replaceWith((Object)RoutingContextAwareSecurityIdentity.addRoutingCtxToIdentityIfMissing(identity, routingContext));
                }
                return HttpAuthenticator.this.createSecurityIdentity(routingContext, i + 1);
            }
        });
    }

    private Uni<HttpAuthenticationMechanism> findBestCandidateMechanism(RoutingContext routingContext, HttpSecurityConfiguration.AuthenticationMechanism pathSpecificMechanism) {
        if (pathSpecificMechanism.instance() != null) {
            HttpAuthenticator.rememberAuthMechanism(routingContext, pathSpecificMechanism);
            return Uni.createFrom().item((Object)pathSpecificMechanism.instance());
        }
        return this.findBestCandidateMechanism(routingContext, pathSpecificMechanism.name(), 0);
    }

    private Uni<HttpAuthenticationMechanism> findBestCandidateMechanism(final RoutingContext routingContext, final String pathSpecificMechanism, final int i) {
        if (i == this.mechanisms.length) {
            return Uni.createFrom().nullItem();
        }
        return this.getPathSpecificMechanism(i, routingContext, pathSpecificMechanism).onItem().transformToUni((Function)new Function<HttpAuthenticationMechanism, Uni<? extends HttpAuthenticationMechanism>>(){

            @Override
            public Uni<? extends HttpAuthenticationMechanism> apply(HttpAuthenticationMechanism mech) {
                if (mech != null) {
                    if (selectAuthMechanismWithAnnotation && !HttpAuthenticator.isAuthMechanismSelected(routingContext)) {
                        return HttpAuthenticator.rememberAuthMechScheme(mech, routingContext).replaceWith((Object)mech);
                    }
                    return Uni.createFrom().item((Object)mech);
                }
                return HttpAuthenticator.this.findBestCandidateMechanism(routingContext, pathSpecificMechanism, i + 1);
            }
        });
    }

    private Uni<HttpAuthenticationMechanism> getPathSpecificMechanism(final int index, final RoutingContext routingContext, final String pathSpecificMechanism) {
        return this.mechanisms[index].getCredentialTransport(routingContext).onItem().transform((Function)new Function<HttpCredentialTransport, HttpAuthenticationMechanism>(){

            @Override
            public HttpAuthenticationMechanism apply(HttpCredentialTransport t) {
                if (t != null && t.getAuthenticationScheme().equalsIgnoreCase(pathSpecificMechanism)) {
                    routingContext.put(HttpAuthenticationMechanism.class.getName(), (Object)HttpAuthenticator.this.mechanisms[index]);
                    HttpAuthenticator.rememberAuthMechanism(routingContext, t.getAuthenticationScheme());
                    return HttpAuthenticator.this.mechanisms[index];
                }
                return null;
            }
        });
    }

    static void selectAuthMechanismWithAnnotation() {
        selectAuthMechanismWithAnnotation = true;
    }

    static void selectAuthMechanism(RoutingContext routingContext, String authMechanism) {
        if (HttpAuthenticator.requestAlreadyAuthenticated(routingContext, authMechanism)) {
            HttpSecurityConfiguration.AuthenticationMechanism authenticationMechanism = HttpAuthenticator.getAuthMechanism(routingContext);
            String previousMechanism = authenticationMechanism != null ? (authenticationMechanism.name() != null ? authenticationMechanism.name() : ((HttpAuthenticationMechanism)ClientProxy.unwrap((Object)authenticationMechanism.instance())).getClass().getName()) : null;
            throw new AuthenticationFailedException("The '%1$s' authentication mechanism is required to authenticate the request but it was already\nauthenticated with the '%2$s' authentication mechanism. It can happen if the '%1$s' is selected with\nan annotation but '%2$s' is activated by the HTTP security policy which is enforced before\nthe JAX-RS chain is run. In such cases, please set the\n'quarkus.http.auth.permission.\"permissions\".applies-to=JAXRS' to all HTTP security policies\nwhich secure the same REST endpoints as the ones secured by the '%1$s' authentication mechanism\nselected with the annotation.\n".formatted(authMechanism, previousMechanism));
        }
        HttpAuthenticator.rememberAuthMechanism(routingContext, authMechanism);
    }

    private static void rememberAuthAttempted(RoutingContext routingContext) {
        routingContext.put(ATTEMPT_AUTH_INVOKED, (Object)Boolean.TRUE);
    }

    private static boolean isAuthMechanismSelected(RoutingContext routingContext) {
        return HttpAuthenticator.getAuthMechanism(routingContext) != null;
    }

    private static boolean requestAlreadyAuthenticated(RoutingContext event, String newAuthMechanism) {
        return event.get(ATTEMPT_AUTH_INVOKED) == Boolean.TRUE && HttpAuthenticator.authenticatedWithDifferentAuthMechanism(newAuthMechanism, event);
    }

    private static boolean authenticatedWithDifferentAuthMechanism(String newAuthMechanism, RoutingContext event) {
        return !newAuthMechanism.equalsIgnoreCase(HttpAuthenticator.getAuthMechanismScheme(event));
    }

    private static Uni<HttpCredentialTransport> rememberAuthMechScheme(HttpAuthenticationMechanism mech, final RoutingContext event) {
        return mech.getCredentialTransport(event).onItem().ifNotNull().invoke((Consumer)new Consumer<HttpCredentialTransport>(){

            @Override
            public void accept(HttpCredentialTransport t) {
                if (t.getAuthenticationScheme() != null) {
                    HttpAuthenticator.rememberAuthMechanism(event, t.getAuthenticationScheme());
                }
            }
        });
    }

    private static void rememberAuthMechanism(RoutingContext event, HttpSecurityConfiguration.AuthenticationMechanism newAuthMechanism) {
        event.put(AUTH_MECHANISM, (Object)newAuthMechanism);
        event.put(HttpAuthenticationMechanism.class.getName(), (Object)newAuthMechanism.instance());
    }

    private static void rememberAuthMechanism(RoutingContext event, String newAuthMechanism) {
        event.put(AUTH_MECHANISM, (Object)new HttpSecurityConfiguration.AuthenticationMechanism(newAuthMechanism, null));
    }

    private static HttpSecurityConfiguration.AuthenticationMechanism getAuthMechanism(RoutingContext event) {
        return (HttpSecurityConfiguration.AuthenticationMechanism)event.get(AUTH_MECHANISM);
    }

    private static String getAuthMechanismScheme(RoutingContext event) {
        HttpSecurityConfiguration.AuthenticationMechanism authenticationMechanism = HttpAuthenticator.getAuthMechanism(event);
        if (authenticationMechanism != null) {
            return authenticationMechanism.name();
        }
        return null;
    }

    static class NoAuthenticationMechanism
    implements HttpAuthenticationMechanism {
        NoAuthenticationMechanism() {
        }

        @Override
        public Uni<SecurityIdentity> authenticate(RoutingContext context, IdentityProviderManager identityProviderManager) {
            return Uni.createFrom().optional(Optional.empty());
        }

        @Override
        public Uni<ChallengeData> getChallenge(RoutingContext context) {
            ChallengeData challengeData = new ChallengeData(HttpResponseStatus.FORBIDDEN.code(), null, null);
            return Uni.createFrom().item((Object)challengeData);
        }

        @Override
        public Set<Class<? extends AuthenticationRequest>> getCredentialTypes() {
            return Collections.singleton(AnonymousAuthenticationRequest.class);
        }
    }
}

