/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clienttype.impl;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.keycloak.client.clienttype.ClientType;
import org.keycloak.models.ClientModel;
import org.keycloak.representations.idm.ClientTypeRepresentation;
import org.keycloak.services.clienttype.client.TypeAwareClientModelDelegate;

public class DefaultClientType
implements ClientType {
    private final ClientTypeRepresentation clientType;
    private final ClientType parentClientType;

    public DefaultClientType(ClientTypeRepresentation clientType, ClientType parentClientType) {
        this.clientType = clientType;
        this.parentClientType = parentClientType;
    }

    public String getName() {
        return this.clientType.getName();
    }

    public boolean isApplicable(String optionName) {
        ClientTypeRepresentation.PropertyConfig propertyConfig = (ClientTypeRepresentation.PropertyConfig)this.clientType.getConfig().get(optionName);
        if (propertyConfig != null) {
            return propertyConfig.getApplicable();
        }
        if (this.parentClientType != null) {
            return this.parentClientType.isApplicable(optionName);
        }
        return true;
    }

    public <T> T getTypeValue(String optionName, Class<T> optionType) {
        ClientTypeRepresentation.PropertyConfig propertyConfig = (ClientTypeRepresentation.PropertyConfig)this.clientType.getConfig().get(optionName);
        if (propertyConfig != null) {
            return optionType.cast(propertyConfig.getValue());
        }
        if (this.parentClientType != null) {
            return (T)this.parentClientType.getTypeValue(optionName, optionType);
        }
        return null;
    }

    public Set<String> getOptionNames() {
        Stream optionNames = this.clientType.getConfig().keySet().stream();
        if (this.parentClientType != null) {
            optionNames = Stream.concat(optionNames, this.parentClientType.getOptionNames().stream());
        }
        return optionNames.collect(Collectors.toSet());
    }

    public ClientModel augment(ClientModel client) {
        return new TypeAwareClientModelDelegate(this, () -> client);
    }
}

