/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clientpolicy.condition;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.representations.idm.ClientPolicyConditionRepresentation;
import org.keycloak.services.clientpolicy.ClientPolicyException;
import org.keycloak.services.clientpolicy.condition.AbstractClientPolicyConditionProviderFactory;
import org.keycloak.services.clientpolicy.condition.ClientPolicyConditionProvider;
import org.keycloak.services.clientpolicy.condition.ClientScopesCondition;
import org.keycloak.util.JsonSerialization;

public class ClientScopesConditionFactory
extends AbstractClientPolicyConditionProviderFactory {
    public static final String PROVIDER_ID = "client-scopes";
    public static final String SCOPES = "scopes";
    public static final String TYPE = "type";
    public static final String DEFAULT = "Default";
    public static final String OPTIONAL = "Optional";
    public static final String ANY = "Any";
    private static final List<ProviderConfigProperty> configProperties = new ArrayList<ProviderConfigProperty>();

    public ClientPolicyConditionProvider create(KeycloakSession session) {
        return new ClientScopesCondition(session);
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public String getHelpText() {
        return "It uses the scopes requested or assigned in advance to the client to determine whether the policy is applied to this client. Condition is evaluated during OpenID Connect authorization request and/or token request.";
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return configProperties;
    }

    public void validateConfiguration(KeycloakSession session, RealmModel realm, ClientPolicyConditionRepresentation conditionRepresentation) throws ClientPolicyException {
        ClientScopesCondition.Configuration configuration = (ClientScopesCondition.Configuration)((Object)JsonSerialization.mapper.convertValue((Object)conditionRepresentation.getConfiguration(), ClientScopesCondition.Configuration.class));
        if (configuration.getScopes() != null && !realm.getClientScopesStream().map(ClientScopeModel::getName).toList().containsAll(configuration.getScopes())) {
            throw new ClientPolicyException("Client scopes not allowed: " + String.valueOf(configuration.getScopes()));
        }
    }

    static {
        ClientScopesConditionFactory.addCommonConfigProperties(configProperties);
        ProviderConfigProperty property = new ProviderConfigProperty(SCOPES, "client-scopes-condition.label", "client-scopes-condition.tooltip", "MultivaluedString", (Object)"offline_access");
        configProperties.add(property);
        property = new ProviderConfigProperty(TYPE, "Scope Type", "If set to 'Default', condition evaluates to true if client has some default scopes of the values specified by the 'Expected Scopes' property. If set to 'Optional', condition evaluates to true if client has some optional scopes of the values specified by the 'Expected Scopes' property and at the same time, the scope were used as a value of 'scope' parameter in the request. If set to 'Any', condition evaluates to true if either of the 'Default' or 'Optional' conditions is satisfied.", "List", (Object)OPTIONAL);
        property.setOptions(Arrays.asList(DEFAULT, OPTIONAL, ANY));
        configProperties.add(property);
    }
}

