/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oid4vc.issuance.credentialbuilder;

import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import org.keycloak.protocol.oid4vc.issuance.credentialbuilder.CredentialBuilder;
import org.keycloak.protocol.oid4vc.issuance.credentialbuilder.CredentialBuilderException;
import org.keycloak.protocol.oid4vc.issuance.credentialbuilder.SdJwtCredentialBody;
import org.keycloak.protocol.oid4vc.model.CredentialBuildConfig;
import org.keycloak.protocol.oid4vc.model.CredentialSubject;
import org.keycloak.protocol.oid4vc.model.VerifiableCredential;
import org.keycloak.sdjwt.DisclosureSpec;
import org.keycloak.sdjwt.SdJwt;
import org.keycloak.sdjwt.SdJwtUtils;

public class SdJwtCredentialBuilder
implements CredentialBuilder {
    public static final String ISSUER_CLAIM = "iss";
    public static final String VERIFIABLE_CREDENTIAL_TYPE_CLAIM = "vct";

    @Override
    public String getSupportedFormat() {
        return "dc+sd-jwt";
    }

    @Override
    public SdJwtCredentialBody buildCredentialBody(VerifiableCredential verifiableCredential, CredentialBuildConfig credentialBuildConfig) throws CredentialBuilderException {
        CredentialSubject credentialSubject = verifiableCredential.getCredentialSubject();
        Map<String, Object> claimSet = credentialSubject.getClaims();
        DisclosureSpec.Builder disclosureSpecBuilder = DisclosureSpec.builder();
        claimSet.entrySet().stream().filter(entry -> !credentialBuildConfig.getSdJwtVisibleClaims().contains(entry.getKey())).forEach(entry -> {
            if (entry instanceof List) {
                List listValue = (List)((Object)entry);
                IntStream.range(0, listValue.size()).forEach(i -> disclosureSpecBuilder.withUndisclosedArrayElt((String)entry.getKey(), Integer.valueOf(i), SdJwtUtils.randomSalt()));
            } else {
                disclosureSpecBuilder.withUndisclosedClaim((String)entry.getKey(), SdJwtUtils.randomSalt());
            }
        });
        claimSet.put(ISSUER_CLAIM, credentialBuildConfig.getCredentialIssuer());
        claimSet.put(VERIFIABLE_CREDENTIAL_TYPE_CLAIM, credentialBuildConfig.getCredentialType());
        if (credentialBuildConfig.getNumberOfDecoys() > 0) {
            IntStream.range(0, credentialBuildConfig.getNumberOfDecoys()).forEach(i -> disclosureSpecBuilder.withDecoyClaim(SdJwtUtils.randomSalt()));
        }
        SdJwt.Builder sdJwtBuilder = SdJwt.builder().withDisclosureSpec(disclosureSpecBuilder.build()).withHashAlgorithm(credentialBuildConfig.getHashAlgorithm()).withJwsType(credentialBuildConfig.getTokenJwsType());
        return new SdJwtCredentialBody(sdJwtBuilder, claimSet);
    }
}

