/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import java.util.Set;
import org.jboss.resteasy.reactive.NoCache;
import org.keycloak.common.ClientConnection;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.representations.idm.LDAPCapabilityRepresentation;
import org.keycloak.representations.idm.TestLdapConnectionRepresentation;
import org.keycloak.services.ErrorResponse;
import org.keycloak.services.managers.LDAPServerCapabilitiesManager;
import org.keycloak.services.resources.admin.AdminEventBuilder;
import org.keycloak.services.resources.admin.fgap.AdminPermissionEvaluator;

public class LdapServerCapabilitiesResource {
    protected final RealmModel realm;
    protected final AdminPermissionEvaluator auth;
    protected final AdminEventBuilder adminEvent;
    protected final ClientConnection clientConnection;
    protected final KeycloakSession session;
    protected final HttpHeaders headers;

    public LdapServerCapabilitiesResource(KeycloakSession session, AdminPermissionEvaluator auth, AdminEventBuilder adminEvent) {
        this.session = session;
        this.auth = auth;
        this.realm = session.getContext().getRealm();
        this.adminEvent = adminEvent;
        this.clientConnection = session.getContext().getConnection();
        this.headers = session.getContext().getRequestHeaders();
    }

    @POST
    @NoCache
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response ldapServerCapabilities(TestLdapConnectionRepresentation config) {
        this.auth.realm().requireManageRealm();
        try {
            Set<LDAPCapabilityRepresentation> ldapCapabilities = LDAPServerCapabilitiesManager.queryServerCapabilities(config, this.session, this.realm);
            return Response.ok().entity(ldapCapabilities).build();
        }
        catch (Exception e) {
            throw ErrorResponse.error((String)"ldapServerCapabilities error", (Response.Status)Response.Status.BAD_REQUEST);
        }
    }
}

