/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.procedure.internal;

import jakarta.persistence.ParameterMode;
import java.util.List;
import org.hibernate.QueryException;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.procedure.FunctionReturn;
import org.hibernate.procedure.internal.AbstractStandardCallableStatementSupport;
import org.hibernate.procedure.spi.ProcedureCallImplementor;
import org.hibernate.procedure.spi.ProcedureParameterImplementor;
import org.hibernate.query.spi.ProcedureParameterMetadataImplementor;
import org.hibernate.sql.exec.internal.JdbcCallImpl;
import org.hibernate.sql.exec.spi.JdbcCallParameterRegistration;
import org.hibernate.sql.exec.spi.JdbcOperationQueryCall;

public class StandardCallableStatementSupport
extends AbstractStandardCallableStatementSupport {
    public static final StandardCallableStatementSupport NO_REF_CURSOR_INSTANCE = new StandardCallableStatementSupport(false);
    public static final StandardCallableStatementSupport REF_CURSOR_INSTANCE = new StandardCallableStatementSupport(true);
    private final boolean supportsRefCursors;
    private final boolean implicitReturn;

    public StandardCallableStatementSupport(boolean supportsRefCursors) {
        this.supportsRefCursors = supportsRefCursors;
        this.implicitReturn = !supportsRefCursors;
    }

    @Override
    public JdbcOperationQueryCall interpretCall(ProcedureCallImplementor<?> procedureCall) {
        StringBuilder buffer;
        int offset;
        String procedureName = procedureCall.getProcedureName();
        FunctionReturn functionReturn = procedureCall.getFunctionReturn();
        ProcedureParameterMetadataImplementor parameterMetadata = procedureCall.getParameterMetadata();
        SharedSessionContractImplementor session = procedureCall.getSession();
        List<ProcedureParameterImplementor<?>> registrations = parameterMetadata.getRegistrationsAsList();
        int paramStringSizeEstimate = functionReturn == null && parameterMetadata.hasNamedParameters() ? registrations.size() * 10 : registrations.size() * 2;
        JdbcCallImpl.Builder builder = new JdbcCallImpl.Builder();
        if (functionReturn != null && !this.implicitReturn) {
            offset = 2;
            buffer = new StringBuilder(11 + procedureName.length() + paramStringSizeEstimate).append("{?=call ");
            builder.setFunctionReturn(functionReturn.toJdbcFunctionReturn(session));
        } else {
            offset = 1;
            buffer = new StringBuilder(9 + procedureName.length() + paramStringSizeEstimate).append("{call ");
        }
        buffer.append(procedureName);
        if (registrations.isEmpty()) {
            buffer.append('(');
        } else {
            int sep = 40;
            for (int i = 0; i < registrations.size(); ++i) {
                ProcedureParameterImplementor<?> parameter = registrations.get(i);
                if (parameter.getMode() == ParameterMode.REF_CURSOR) {
                    this.verifyRefCursorSupport(session.getJdbcServices().getJdbcEnvironment().getDialect());
                }
                buffer.append((char)sep);
                JdbcCallParameterRegistration registration = parameter.toJdbcParameterRegistration(i + offset, procedureCall);
                if (parameter.getName() != null && session.getJdbcServices().getExtractedMetaDataSupport().supportsNamedParameters() && session.getFactory().getSessionFactoryOptions().isPassProcedureParameterNames()) {
                    this.appendNameParameter(buffer, parameter, registration);
                } else {
                    buffer.append("?");
                }
                sep = 44;
                builder.addParameterRegistration(registration);
            }
        }
        buffer.append(")}");
        builder.setCallableName(buffer.toString());
        return builder.buildJdbcCall();
    }

    protected void appendNameParameter(StringBuilder buffer, ProcedureParameterImplementor<?> parameter, JdbcCallParameterRegistration registration) {
        buffer.append('?');
    }

    private void verifyRefCursorSupport(Dialect dialect) {
        if (!this.supportsRefCursors) {
            throw new QueryException("Dialect [" + dialect.getClass().getName() + "] not known to support REF_CURSOR parameters");
        }
    }
}

