/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.jdbc.internal;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.AssertionFailure;
import org.hibernate.ScrollMode;
import org.hibernate.engine.jdbc.JdbcLogging;
import org.hibernate.engine.jdbc.internal.JdbcCoordinatorImpl;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.jdbc.spi.SqlExceptionHelper;
import org.hibernate.engine.jdbc.spi.StatementPreparer;
import org.hibernate.event.monitor.spi.DiagnosticEvent;
import org.hibernate.event.monitor.spi.EventMonitor;
import org.hibernate.resource.jdbc.spi.JdbcEventHandler;
import org.hibernate.resource.jdbc.spi.JdbcSessionContext;
import org.hibernate.resource.jdbc.spi.JdbcSessionOwner;
import org.hibernate.resource.jdbc.spi.LogicalConnectionImplementor;

class StatementPreparerImpl
implements StatementPreparer {
    private final JdbcCoordinatorImpl jdbcCoordinator;
    private final JdbcServices jdbcServices;

    StatementPreparerImpl(JdbcCoordinatorImpl jdbcCoordinator, JdbcServices jdbcServices) {
        this.jdbcCoordinator = jdbcCoordinator;
        this.jdbcServices = jdbcServices;
    }

    protected final JdbcSessionContext settings() {
        return this.jdbcCoordinator.getJdbcSessionOwner().getJdbcSessionContext();
    }

    protected final Connection connection() {
        return this.logicalConnection().getPhysicalConnection();
    }

    protected final LogicalConnectionImplementor logicalConnection() {
        return this.jdbcCoordinator.getLogicalConnection();
    }

    protected final SqlExceptionHelper sqlExceptionHelper() {
        return this.jdbcServices.getSqlExceptionHelper();
    }

    @Override
    public Statement createStatement() {
        try {
            Statement statement = this.connection().createStatement();
            this.jdbcCoordinator.getLogicalConnection().getResourceRegistry().register(statement, true);
            return statement;
        }
        catch (SQLException e) {
            throw this.sqlExceptionHelper().convert(e, "Could not create statement");
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql) {
        return this.prepareStatement(sql, false);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, boolean isCallable) {
        this.jdbcCoordinator.executeBatch();
        return this.buildPreparedStatementPreparationTemplate(sql, isCallable).prepareStatement();
    }

    @Override
    public CallableStatement prepareCallableStatement(String sql) {
        this.jdbcCoordinator.executeBatch();
        return (CallableStatement)this.prepareStatement(sql, true);
    }

    private StatementPreparationTemplate buildPreparedStatementPreparationTemplate(String sql, final boolean isCallable) {
        return new StatementPreparationTemplate(sql){

            @Override
            protected PreparedStatement doPrepare() throws SQLException {
                return isCallable ? StatementPreparerImpl.this.connection().prepareCall(this.sql) : StatementPreparerImpl.this.connection().prepareStatement(this.sql);
            }
        };
    }

    private void checkAutoGeneratedKeysSupportEnabled() {
        if (!this.settings().isGetGeneratedKeysEnabled()) {
            throw new AssertionFailure("getGeneratedKeys() support is not enabled");
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, final int autoGeneratedKeys) {
        if (autoGeneratedKeys == 1) {
            this.checkAutoGeneratedKeysSupportEnabled();
        }
        this.jdbcCoordinator.executeBatch();
        return new StatementPreparationTemplate(sql){

            @Override
            public PreparedStatement doPrepare() throws SQLException {
                return StatementPreparerImpl.this.connection().prepareStatement(this.sql, autoGeneratedKeys);
            }
        }.prepareStatement();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, final String[] columnNames) {
        this.checkAutoGeneratedKeysSupportEnabled();
        this.jdbcCoordinator.executeBatch();
        return new StatementPreparationTemplate(sql){

            @Override
            public PreparedStatement doPrepare() throws SQLException {
                return StatementPreparerImpl.this.connection().prepareStatement(this.sql, columnNames);
            }
        }.prepareStatement();
    }

    @Override
    public PreparedStatement prepareQueryStatement(String sql, final boolean isCallable, @Nullable ScrollMode scrollMode) {
        int resultSetType;
        if (scrollMode != null && scrollMode != ScrollMode.FORWARD_ONLY) {
            if (!this.settings().isScrollableResultSetsEnabled()) {
                throw new AssertionFailure("Scrollable result sets are not enabled");
            }
            resultSetType = scrollMode.toResultSetType();
        } else {
            resultSetType = 1003;
        }
        PreparedStatement ps = new QueryStatementPreparationTemplate(sql){

            @Override
            public PreparedStatement doPrepare() throws SQLException {
                return isCallable ? StatementPreparerImpl.this.connection().prepareCall(this.sql, resultSetType, 1007) : StatementPreparerImpl.this.connection().prepareStatement(this.sql, resultSetType, 1007);
            }
        }.prepareStatement();
        this.jdbcCoordinator.registerLastQuery(ps);
        return ps;
    }

    private void setStatementFetchSize(PreparedStatement statement) throws SQLException {
        Integer fetchSize = this.settings().getFetchSizeOrNull();
        if (fetchSize != null) {
            JdbcLogging.JDBC_MESSAGE_LOGGER.settingFetchSize(fetchSize);
            statement.setFetchSize(fetchSize);
        } else if (JdbcLogging.JDBC_MESSAGE_LOGGER.isDebugEnabled()) {
            int defaultFetchSize = statement.getFetchSize();
            if (defaultFetchSize > 0 && defaultFetchSize < 100) {
                JdbcLogging.JDBC_MESSAGE_LOGGER.lowFetchSize(defaultFetchSize);
            }
        } else if (JdbcLogging.JDBC_MESSAGE_LOGGER.isTraceEnabled()) {
            JdbcLogging.JDBC_MESSAGE_LOGGER.fetchSize(statement.getFetchSize());
        }
    }

    private abstract class StatementPreparationTemplate {
        protected final String sql;

        protected StatementPreparationTemplate(String incomingSql) {
            String inspectedSql = StatementPreparerImpl.this.jdbcCoordinator.getJdbcSessionOwner().getJdbcSessionContext().getStatementInspector().inspect(incomingSql);
            this.sql = inspectedSql == null ? incomingSql : inspectedSql;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public PreparedStatement prepareStatement() {
            try {
                PreparedStatement preparedStatement;
                StatementPreparerImpl.this.jdbcServices.getSqlStatementLogger().logStatement(this.sql);
                JdbcSessionOwner jdbcSessionOwner = StatementPreparerImpl.this.jdbcCoordinator.getJdbcSessionOwner();
                JdbcEventHandler observer = jdbcSessionOwner.getJdbcSessionContext().getEventHandler();
                EventMonitor eventMonitor = jdbcSessionOwner.getEventMonitor();
                DiagnosticEvent jdbcPreparedStatementCreation = eventMonitor.beginJdbcPreparedStatementCreationEvent();
                try {
                    observer.jdbcPrepareStatementStart();
                    preparedStatement = this.doPrepare();
                    this.setStatementTimeout(preparedStatement);
                }
                finally {
                    eventMonitor.completeJdbcPreparedStatementCreationEvent(jdbcPreparedStatementCreation, this.sql);
                    observer.jdbcPrepareStatementEnd();
                }
                this.postProcess(preparedStatement);
                return preparedStatement;
            }
            catch (SQLException e) {
                throw StatementPreparerImpl.this.sqlExceptionHelper().convert(e, "Could not prepare statement", this.sql);
            }
        }

        protected abstract PreparedStatement doPrepare() throws SQLException;

        public void postProcess(PreparedStatement preparedStatement) throws SQLException {
            StatementPreparerImpl.this.jdbcCoordinator.getLogicalConnection().getResourceRegistry().register(preparedStatement, true);
        }

        private void setStatementTimeout(PreparedStatement preparedStatement) throws SQLException {
            int remainingTransactionTimeOutPeriod = StatementPreparerImpl.this.jdbcCoordinator.determineRemainingTransactionTimeOutPeriod();
            if (remainingTransactionTimeOutPeriod > 0) {
                preparedStatement.setQueryTimeout(remainingTransactionTimeOutPeriod);
            }
        }
    }

    private abstract class QueryStatementPreparationTemplate
    extends StatementPreparationTemplate {
        protected QueryStatementPreparationTemplate(String sql) {
            super(sql);
        }

        @Override
        public void postProcess(PreparedStatement preparedStatement) throws SQLException {
            super.postProcess(preparedStatement);
            StatementPreparerImpl.this.setStatementFetchSize(preparedStatement);
        }
    }
}

