/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.impl;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import jakarta.enterprise.context.spi.CreationalContext;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.jboss.logging.Logger;

public class InvokerCleanupTasks
implements Consumer<Runnable> {
    private static final Logger LOG = Logger.getLogger(InvokerCleanupTasks.class);
    private final Set<Runnable> finishTasks = ConcurrentHashMap.newKeySet();

    @Override
    public void accept(Runnable task) {
        if (task != null) {
            this.finishTasks.add(task);
        }
    }

    public void finish() {
        for (Runnable task : this.finishTasks) {
            try {
                task.run();
            }
            catch (Exception e) {
                if (LOG.isDebugEnabled()) {
                    LOG.error((Object)"Exception thrown by an invoker cleanup task", (Throwable)e);
                    continue;
                }
                LOG.error((Object)("Exception thrown by an invoker cleanup task: " + String.valueOf(e)));
            }
        }
        this.finishTasks.clear();
    }

    public static <T> CompletionStage<T> deferRelease(CreationalContext<?> cc, CompletionStage<T> completionStage) {
        CompletableFuture result = new CompletableFuture();
        completionStage.whenComplete((value, error) -> {
            cc.release();
            if (error == null) {
                result.complete(value);
            } else {
                result.completeExceptionally((Throwable)error);
            }
        });
        return result;
    }

    public static <T> Uni<T> deferRelease(CreationalContext<?> cc, Uni<T> uni) {
        return uni.onTermination().invoke(() -> cc.release());
    }

    public static <T> Multi<T> deferRelease(CreationalContext<?> cc, Multi<T> multi) {
        return multi.onTermination().invoke(() -> cc.release());
    }
}

