/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.tools;

import java.util.Arrays;
import java.util.List;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.connect.transforms.Cast;
import org.apache.kafka.connect.transforms.DropHeaders;
import org.apache.kafka.connect.transforms.ExtractField;
import org.apache.kafka.connect.transforms.Filter;
import org.apache.kafka.connect.transforms.Flatten;
import org.apache.kafka.connect.transforms.HeaderFrom;
import org.apache.kafka.connect.transforms.HoistField;
import org.apache.kafka.connect.transforms.InsertField;
import org.apache.kafka.connect.transforms.InsertHeader;
import org.apache.kafka.connect.transforms.MaskField;
import org.apache.kafka.connect.transforms.RegexRouter;
import org.apache.kafka.connect.transforms.ReplaceField;
import org.apache.kafka.connect.transforms.SetSchemaMetadata;
import org.apache.kafka.connect.transforms.TimestampConverter;
import org.apache.kafka.connect.transforms.TimestampRouter;
import org.apache.kafka.connect.transforms.ValueToKey;

public class TransformationDoc {
    private static final List<DocInfo> TRANSFORMATIONS = Arrays.asList(new DocInfo(Cast.class.getName(), Cast.OVERVIEW_DOC, Cast.CONFIG_DEF), new DocInfo(DropHeaders.class.getName(), "Removes one or more headers from each record.", DropHeaders.CONFIG_DEF), new DocInfo(ExtractField.class.getName(), ExtractField.OVERVIEW_DOC, ExtractField.CONFIG_DEF), new DocInfo(Filter.class.getName(), "Drops all records, filtering them from subsequent transformations in the chain. This is intended to be used conditionally to filter out records matching (or not matching) a particular Predicate.", Filter.CONFIG_DEF), new DocInfo(Flatten.class.getName(), Flatten.OVERVIEW_DOC, Flatten.CONFIG_DEF), new DocInfo(HeaderFrom.class.getName(), HeaderFrom.OVERVIEW_DOC, HeaderFrom.CONFIG_DEF), new DocInfo(HoistField.class.getName(), HoistField.OVERVIEW_DOC, HoistField.CONFIG_DEF), new DocInfo(InsertField.class.getName(), InsertField.OVERVIEW_DOC, InsertField.CONFIG_DEF), new DocInfo(InsertHeader.class.getName(), "Add a header to each record.", InsertHeader.CONFIG_DEF), new DocInfo(MaskField.class.getName(), MaskField.OVERVIEW_DOC, MaskField.CONFIG_DEF), new DocInfo(RegexRouter.class.getName(), "Update the record topic using the configured regular expression and replacement string.<p/>Under the hood, the regex is compiled to a <code>java.util.regex.Pattern</code>. If the pattern matches the input topic, <code>java.util.regex.Matcher#replaceFirst()</code> is used with the replacement string to obtain the new topic.", RegexRouter.CONFIG_DEF), new DocInfo(ReplaceField.class.getName(), ReplaceField.OVERVIEW_DOC, ReplaceField.CONFIG_DEF), new DocInfo(SetSchemaMetadata.class.getName(), SetSchemaMetadata.OVERVIEW_DOC, SetSchemaMetadata.CONFIG_DEF), new DocInfo(TimestampConverter.class.getName(), TimestampConverter.OVERVIEW_DOC, TimestampConverter.CONFIG_DEF), new DocInfo(TimestampRouter.class.getName(), "Update the record's topic field as a function of the original topic value and the record timestamp.<p/>This is mainly useful for sink connectors, since the topic field is often used to determine the equivalent entity name in the destination system(e.g. database table or search index name).", TimestampRouter.CONFIG_DEF), new DocInfo(ValueToKey.class.getName(), "Replace the record key with a new key formed from a subset of fields in the record value.", ValueToKey.CONFIG_DEF));

    private static String toHtml() {
        StringBuilder b = new StringBuilder();
        for (DocInfo docInfo : TRANSFORMATIONS) {
            b.append("<div id=\"" + docInfo.transformationName + "\">\n");
            b.append("<h5>");
            b.append("<a href=\"#" + docInfo.transformationName + "\">" + docInfo.transformationName + "</a>");
            b.append("</h5>\n");
            b.append(docInfo.overview + "\n");
            b.append("<p/>\n");
            b.append(docInfo.configDef.toHtml(6, key -> docInfo.transformationName + "_" + key) + "\n");
            b.append("</div>\n");
        }
        return b.toString();
    }

    public static void main(String ... args) {
        System.out.println(TransformationDoc.toHtml());
    }

    private record DocInfo(String transformationName, String overview, ConfigDef configDef) {
    }
}

