/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools.consumer;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.MessageFormatter;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.coordinator.common.runtime.CoordinatorRecord;
import org.apache.kafka.coordinator.common.runtime.CoordinatorRecordSerde;
import org.apache.kafka.coordinator.common.runtime.Deserializer;

public abstract class CoordinatorRecordMessageFormatter
implements MessageFormatter {
    private static final String TYPE = "type";
    private static final String VERSION = "version";
    private static final String DATA = "data";
    private static final String KEY = "key";
    private static final String VALUE = "value";
    private final CoordinatorRecordSerde serde;

    public CoordinatorRecordMessageFormatter(CoordinatorRecordSerde serde) {
        this.serde = serde;
    }

    public void writeTo(ConsumerRecord<byte[], byte[]> consumerRecord, PrintStream output) {
        if (Objects.isNull(consumerRecord.key())) {
            return;
        }
        ObjectNode json = new ObjectNode(JsonNodeFactory.instance);
        try {
            CoordinatorRecord record = this.serde.deserialize(ByteBuffer.wrap((byte[])consumerRecord.key()), consumerRecord.value() != null ? ByteBuffer.wrap((byte[])consumerRecord.value()) : null);
            if (!this.isRecordTypeAllowed(record.key().apiKey())) {
                return;
            }
            json.putObject(KEY).put(TYPE, record.key().apiKey()).set(DATA, this.keyAsJson(record.key()));
            if (Objects.nonNull(record.value())) {
                json.putObject(VALUE).put(VERSION, record.value().version()).set(DATA, this.valueAsJson(record.value().message(), record.value().version()));
            } else {
                json.set(VALUE, (JsonNode)NullNode.getInstance());
            }
        }
        catch (Deserializer.UnknownRecordTypeException ex) {
            return;
        }
        catch (RuntimeException ex) {
            throw new RuntimeException("Could not read record at offset " + consumerRecord.offset() + " due to: " + ex.getMessage(), ex);
        }
        try {
            output.write(json.toString().getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected abstract boolean isRecordTypeAllowed(short var1);

    protected abstract JsonNode keyAsJson(ApiMessage var1);

    protected abstract JsonNode valueAsJson(ApiMessage var1, short var2);
}

