/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.4.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Compute an approximate distance from an interpolated isocontour to the
close grid points.


For standard level set algorithms, it is useful to periodically
reinitialize the evolving image to prevent numerical accuracy problems
in computing derivatives. This reinitialization is done by computing a
signed distance map to the current level set. This class provides the
first step in this reinitialization by computing an estimate of the
distance from the interpolated isocontour to the pixels (or voxels)
that are close to it, i.e. for which the isocontour crosses a segment
between them and one of their direct neighbors. This class supports
narrowbanding. If the input narrowband is provided, the algorithm will
only locate the level set within the input narrowband.

Implementation of this class is based on Fast and Accurate
Redistancing for Level Set Methods Krissian K. and Westin C.F.,
EUROCAST NeuroImaging Workshop Las Palmas Spain, Ninth International
Conference on Computer Aided Systems Theory , pages 48-51, Feb 2003.
See:
 itk::simple::IsoContourDistance for the procedural interface

 itk::IsoContourDistanceImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkIsoContourDistanceImageFilter.h
*/
public class IsoContourDistanceImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected IsoContourDistanceImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.IsoContourDistanceImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(IsoContourDistanceImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(IsoContourDistanceImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::IsoContourDistanceImageFilter::~IsoContourDistanceImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_IsoContourDistanceImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::IsoContourDistanceImageFilter::IsoContourDistanceImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  IsoContourDistanceImageFilter() {
    this(SimpleITKJNI.new_IsoContourDistanceImageFilter(), true);
  }

  /**
Self&amp; itk::simple::IsoContourDistanceImageFilter::SetLevelSetValue(double LevelSetValue)

Set/Get the value of the level set to be located. The default value is
0.

*/
public  void setLevelSetValue(double LevelSetValue) {
    SimpleITKJNI.IsoContourDistanceImageFilter_setLevelSetValue(swigCPtr, this, LevelSetValue);
  }

  /**
double itk::simple::IsoContourDistanceImageFilter::GetLevelSetValue() const

Set/Get the value of the level set to be located. The default value is
0.

*/
public  double getLevelSetValue() {
    return SimpleITKJNI.IsoContourDistanceImageFilter_getLevelSetValue(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::IsoContourDistanceImageFilter::SetFarValue(double FarValue)

Set/Get the value of the level set to be located. The default value is
0.

*/
public  void setFarValue(double FarValue) {
    SimpleITKJNI.IsoContourDistanceImageFilter_setFarValue(swigCPtr, this, FarValue);
  }

  /**
double itk::simple::IsoContourDistanceImageFilter::GetFarValue() const

Set/Get the value of the level set to be located. The default value is
0.

*/
public  double getFarValue() {
    return SimpleITKJNI.IsoContourDistanceImageFilter_getFarValue(swigCPtr, this);
  }

  /**
std::string itk::simple::IsoContourDistanceImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.IsoContourDistanceImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::IsoContourDistanceImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.IsoContourDistanceImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::IsoContourDistanceImageFilter::Execute(const Image &amp;image1)

Execute the filter on the input image

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.IsoContourDistanceImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

}
