/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.logging.events;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.gradle.api.logging.LogLevel;
import org.gradle.internal.SystemProperties;
import org.gradle.internal.logging.events.LogLevelConverter;
import org.gradle.internal.logging.events.RenderableOutputEvent;
import org.gradle.internal.logging.events.operations.StyledTextBuildOperationProgressDetails;
import org.gradle.internal.logging.text.StyledTextOutput;
import org.gradle.internal.operations.OperationIdentifier;
import org.gradle.internal.operations.logging.LogEventLevel;
import org.jspecify.annotations.Nullable;

public class StyledTextOutputEvent
extends RenderableOutputEvent
implements StyledTextBuildOperationProgressDetails {
    public static final Span EOL = new Span(SystemProperties.getInstance().getLineSeparator());
    private final List<Span> spans;

    public StyledTextOutputEvent(long timestamp, String category, LogLevel logLevel, @Nullable OperationIdentifier buildOperationIdentifier, String text) {
        this(timestamp, category, logLevel, buildOperationIdentifier, Collections.singletonList(new Span(StyledTextOutput.Style.Normal, text)));
    }

    public StyledTextOutputEvent(long timestamp, String category, LogLevel logLevel, @Nullable OperationIdentifier buildOperationIdentifier, List<Span> spans) {
        super(timestamp, category, logLevel, buildOperationIdentifier);
        this.spans = new ArrayList<Span>(spans);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append('[').append(this.getLogLevel()).append("] [");
        builder.append(this.getCategory()).append("] ");
        for (Span span : this.spans) {
            builder.append('<');
            builder.append(span.style);
            builder.append(">");
            builder.append(span.text);
            builder.append("</");
            builder.append(span.style);
            builder.append(">");
        }
        return builder.toString();
    }

    public StyledTextOutputEvent withLogLevel(LogLevel logLevel) {
        return new StyledTextOutputEvent(this.getTimestamp(), this.getCategory(), logLevel, this.getBuildOperationId(), this.spans);
    }

    @Override
    public StyledTextOutputEvent withBuildOperationId(OperationIdentifier buildOperationId) {
        return new StyledTextOutputEvent(this.getTimestamp(), this.getCategory(), this.getLogLevel(), buildOperationId, this.spans);
    }

    public List<Span> getSpans() {
        return this.spans;
    }

    @Override
    public void render(StyledTextOutput output) {
        for (Span span : this.spans) {
            output.style(span.style);
            output.text((Object)span.text);
        }
    }

    public LogEventLevel getLevel() {
        return LogLevelConverter.convert(this.getLogLevel());
    }

    public static class Span
    implements StyledTextBuildOperationProgressDetails.Span {
        private final String text;
        private final StyledTextOutput.Style style;

        public Span(StyledTextOutput.Style style, String text) {
            this.style = style;
            this.text = text;
        }

        public Span(String text) {
            this.style = StyledTextOutput.Style.Normal;
            this.text = text;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            Span other = (Span)obj;
            return this.text.equals(other.text) && this.style.equals((Object)other.style);
        }

        public int hashCode() {
            return this.text.hashCode() ^ this.style.hashCode();
        }

        public StyledTextOutput.Style getStyle() {
            return this.style;
        }

        public String getStyleName() {
            return this.getStyle().name();
        }

        public String getText() {
            return this.text;
        }

        public String toString() {
            return this.style.toString() + ":" + this.text;
        }
    }
}

