/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.attributes;

import javax.inject.Inject;
import org.gradle.api.internal.attributes.immutable.ImmutableAttributesSchema;
import org.gradle.api.internal.attributes.immutable.ImmutableAttributesSchemaFactory;
import org.gradle.api.internal.attributes.immutable.artifact.ImmutableArtifactTypeRegistryFactory;
import org.gradle.api.internal.attributes.matching.AttributeMatcher;
import org.gradle.api.internal.attributes.matching.CachingAttributeSelectionSchema;
import org.gradle.api.internal.attributes.matching.DefaultAttributeMatcher;
import org.gradle.api.internal.attributes.matching.DefaultAttributeSelectionSchema;
import org.gradle.internal.model.InMemoryCacheFactory;
import org.gradle.internal.model.InMemoryLoadingCache;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;

@ServiceScope(value={Scope.BuildSession.class})
public class AttributeSchemaServices {
    private final ImmutableAttributesSchemaFactory attributesSchemaFactory;
    private final ImmutableArtifactTypeRegistryFactory artifactTypeRegistryFactory;
    private final InMemoryCacheFactory cacheFactory;
    private final InMemoryLoadingCache<ImmutableAttributesSchema, AttributeMatcher> matchers;

    @Inject
    public AttributeSchemaServices(ImmutableAttributesSchemaFactory attributesSchemaFactory, ImmutableArtifactTypeRegistryFactory artifactTypeRegistryFactory, InMemoryCacheFactory cacheFactory) {
        this.attributesSchemaFactory = attributesSchemaFactory;
        this.artifactTypeRegistryFactory = artifactTypeRegistryFactory;
        this.cacheFactory = cacheFactory;
        this.matchers = cacheFactory.createIdentityCache(this::createMatcher);
    }

    public ImmutableAttributesSchemaFactory getSchemaFactory() {
        return this.attributesSchemaFactory;
    }

    public ImmutableArtifactTypeRegistryFactory getArtifactTypeRegistryFactory() {
        return this.artifactTypeRegistryFactory;
    }

    public AttributeMatcher getMatcher(ImmutableAttributesSchema consumer, ImmutableAttributesSchema producer) {
        ImmutableAttributesSchema merged = this.attributesSchemaFactory.concat(consumer, producer);
        return (AttributeMatcher)this.matchers.get((Object)merged);
    }

    private DefaultAttributeMatcher createMatcher(ImmutableAttributesSchema schema) {
        return new DefaultAttributeMatcher(new CachingAttributeSelectionSchema(new DefaultAttributeSelectionSchema(schema), this.cacheFactory), this.cacheFactory);
    }
}

