/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.jpeg.drew;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import tim.prune.jpeg.JpegData;
import tim.prune.jpeg.drew.ByteArrayReader;
import tim.prune.jpeg.drew.ExifException;
import tim.prune.jpeg.drew.TiffProcessor;

public class ExifReader {
    private static final int MAGIC_JPEG_BYTE_1 = 255;
    private static final int MAGIC_JPEG_BYTE_2 = 216;
    private static final String JPEG_EXIF_SEGMENT_PREAMBLE = "Exif\u0000\u0000";
    private static final byte SEGMENT_SOS = -38;
    private static final byte MARKER_EOI = -39;

    public static JpegData readMetadata(File file) throws ExifException {
        JpegData jpegData = new JpegData();
        BufferedInputStream bufferedInputStream = null;
        try {
            try {
                bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                byte[] byArray = ExifReader.readSegments(bufferedInputStream);
                if (byArray != null) {
                    ExifReader.extract(byArray, jpegData);
                }
            }
            catch (IOException iOException) {
                throw new ExifException("IO Exception: " + iOException.getMessage());
            }
        }
        catch (Throwable throwable) {
            if (bufferedInputStream != null) {
                try {
                    bufferedInputStream.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (bufferedInputStream != null) {
            try {
                bufferedInputStream.close();
            }
            catch (IOException iOException) {}
        }
        return jpegData;
    }

    private static byte[] readSegments(BufferedInputStream bufferedInputStream) throws ExifException, IOException {
        byte[] byArray;
        byte by;
        int n = bufferedInputStream.read() & 0xFF;
        int n2 = bufferedInputStream.read() & 0xFF;
        if (n != 255 || n2 != 216) {
            throw new ExifException("Jpeg file failed Magic check");
        }
        do {
            short s;
            if ((s = (short)bufferedInputStream.read()) != 255) {
                throw new ExifException("Expected JPEG segment start identifier 0xFF, not 0x" + Integer.toHexString(s).toUpperCase());
            }
            by = (byte)bufferedInputStream.read();
            while (by == -1) {
                by = (byte)bufferedInputStream.read();
            }
            if (by == 0) {
                throw new ExifException("Expected non-zero byte as part of JPEG marker identifier");
            }
            if (by == -38) {
                return null;
            }
            if (by == -39) {
                return null;
            }
            int n3 = (bufferedInputStream.read() << 8) + bufferedInputStream.read();
            if ((n3 -= 2) < 0) {
                throw new ExifException("JPEG segment size would be less than zero");
            }
            byArray = new byte[n3];
            int n4 = bufferedInputStream.read(byArray, 0, n3);
            if (n4 == n3) continue;
            throw new ExifException("Tried to read " + n3 + " bytes but only got " + n4);
        } while (-31 != by || !ExifReader.canProcess(byArray));
        return byArray;
    }

    private static boolean canProcess(byte[] byArray) {
        return byArray.length >= JPEG_EXIF_SEGMENT_PREAMBLE.length() && new String(byArray, 0, JPEG_EXIF_SEGMENT_PREAMBLE.length()).equalsIgnoreCase(JPEG_EXIF_SEGMENT_PREAMBLE);
    }

    private static void extract(byte[] byArray, JpegData jpegData) {
        if (byArray == null) {
            throw new NullPointerException("segmentBytes cannot be null");
        }
        try {
            ByteArrayReader byteArrayReader = new ByteArrayReader(byArray);
            try {
                if (!byteArrayReader.getString(0, JPEG_EXIF_SEGMENT_PREAMBLE.length()).equals(JPEG_EXIF_SEGMENT_PREAMBLE)) {
                    System.err.println("Invalid JPEG Exif segment preamble");
                    return;
                }
            }
            catch (ExifException exifException) {
                exifException.printStackTrace(System.err);
                return;
            }
            TiffProcessor.processTiff(byteArrayReader, jpegData, JPEG_EXIF_SEGMENT_PREAMBLE.length());
        }
        catch (ExifException exifException) {
            exifException.printStackTrace(System.err);
        }
    }
}

