﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/networkflowmonitor/NetworkFlowMonitorRequest.h>
#include <aws/networkflowmonitor/NetworkFlowMonitor_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Http {
class URI;
}  // namespace Http
namespace NetworkFlowMonitor {
namespace Model {

/**
 */
class GetQueryResultsWorkloadInsightsTopContributorsDataRequest : public NetworkFlowMonitorRequest {
 public:
  AWS_NETWORKFLOWMONITOR_API GetQueryResultsWorkloadInsightsTopContributorsDataRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "GetQueryResultsWorkloadInsightsTopContributorsData"; }

  AWS_NETWORKFLOWMONITOR_API Aws::String SerializePayload() const override;

  AWS_NETWORKFLOWMONITOR_API void AddQueryStringParameters(Aws::Http::URI& uri) const override;

  ///@{
  /**
   * <p>The identifier for the scope that includes the resources you want to get data
   * results for. A scope ID is an internally-generated identifier that includes all
   * the resources for a specific root account.</p>
   */
  inline const Aws::String& GetScopeId() const { return m_scopeId; }
  inline bool ScopeIdHasBeenSet() const { return m_scopeIdHasBeenSet; }
  template <typename ScopeIdT = Aws::String>
  void SetScopeId(ScopeIdT&& value) {
    m_scopeIdHasBeenSet = true;
    m_scopeId = std::forward<ScopeIdT>(value);
  }
  template <typename ScopeIdT = Aws::String>
  GetQueryResultsWorkloadInsightsTopContributorsDataRequest& WithScopeId(ScopeIdT&& value) {
    SetScopeId(std::forward<ScopeIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The identifier for the query. A query ID is an internally-generated
   * identifier for a specific query returned from an API call to create a query.</p>
   */
  inline const Aws::String& GetQueryId() const { return m_queryId; }
  inline bool QueryIdHasBeenSet() const { return m_queryIdHasBeenSet; }
  template <typename QueryIdT = Aws::String>
  void SetQueryId(QueryIdT&& value) {
    m_queryIdHasBeenSet = true;
    m_queryId = std::forward<QueryIdT>(value);
  }
  template <typename QueryIdT = Aws::String>
  GetQueryResultsWorkloadInsightsTopContributorsDataRequest& WithQueryId(QueryIdT&& value) {
    SetQueryId(std::forward<QueryIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The token for the next set of results. You receive this token from a previous
   * call.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  inline bool NextTokenHasBeenSet() const { return m_nextTokenHasBeenSet; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  GetQueryResultsWorkloadInsightsTopContributorsDataRequest& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The number of query results that you want to return with this call.</p>
   */
  inline int GetMaxResults() const { return m_maxResults; }
  inline bool MaxResultsHasBeenSet() const { return m_maxResultsHasBeenSet; }
  inline void SetMaxResults(int value) {
    m_maxResultsHasBeenSet = true;
    m_maxResults = value;
  }
  inline GetQueryResultsWorkloadInsightsTopContributorsDataRequest& WithMaxResults(int value) {
    SetMaxResults(value);
    return *this;
  }
  ///@}
 private:
  Aws::String m_scopeId;

  Aws::String m_queryId;

  Aws::String m_nextToken;

  int m_maxResults{0};
  bool m_scopeIdHasBeenSet = false;
  bool m_queryIdHasBeenSet = false;
  bool m_nextTokenHasBeenSet = false;
  bool m_maxResultsHasBeenSet = false;
};

}  // namespace Model
}  // namespace NetworkFlowMonitor
}  // namespace Aws
