/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.record;

import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;

public enum CompressionType {
    NONE(0, "none", 1.0f),
    GZIP(1, "gzip", 1.0f){
        public static final int MIN_LEVEL = 1;
        public static final int MAX_LEVEL = 9;
        public static final int DEFAULT_LEVEL = -1;

        @Override
        public int defaultLevel() {
            return -1;
        }

        @Override
        public int maxLevel() {
            return 9;
        }

        @Override
        public int minLevel() {
            return 1;
        }

        @Override
        public ConfigDef.Validator levelValidator() {
            return ConfigDef.LambdaValidator.with((name, value) -> {
                if (value == null) {
                    throw new ConfigException((String)name, null, "Value must be non-null");
                }
                int level = ((Number)value).intValue();
                if (level > 9 || level < 1 && level != -1) {
                    throw new ConfigException((String)name, value, "Value must be between 1 and 9 or equal to -1");
                }
            }, () -> "[1,...,9] or -1");
        }
    }
    ,
    SNAPPY(2, "snappy", 1.0f),
    LZ4(3, "lz4", 1.0f){
        private static final int MIN_LEVEL = 1;
        private static final int MAX_LEVEL = 17;
        private static final int DEFAULT_LEVEL = 9;

        @Override
        public int defaultLevel() {
            return 9;
        }

        @Override
        public int maxLevel() {
            return 17;
        }

        @Override
        public int minLevel() {
            return 1;
        }

        @Override
        public ConfigDef.Validator levelValidator() {
            return ConfigDef.Range.between(1, 17);
        }
    }
    ,
    ZSTD(4, "zstd", 1.0f){
        private static final int MIN_LEVEL = -131072;
        private static final int MAX_LEVEL = 22;
        private static final int DEFAULT_LEVEL = 3;

        @Override
        public int defaultLevel() {
            return 3;
        }

        @Override
        public int maxLevel() {
            return 22;
        }

        @Override
        public int minLevel() {
            return -131072;
        }

        @Override
        public ConfigDef.Validator levelValidator() {
            return ConfigDef.Range.between(-131072, 22);
        }
    };

    public final byte id;
    public final String name;
    public final float rate;

    private CompressionType(byte id, String name, float rate) {
        this.id = id;
        this.name = name;
        this.rate = rate;
    }

    public static CompressionType forId(int id) {
        switch (id) {
            case 0: {
                return NONE;
            }
            case 1: {
                return GZIP;
            }
            case 2: {
                return SNAPPY;
            }
            case 3: {
                return LZ4;
            }
            case 4: {
                return ZSTD;
            }
        }
        throw new IllegalArgumentException("Unknown compression type id: " + id);
    }

    public static CompressionType forName(String name) {
        if (CompressionType.NONE.name.equals(name)) {
            return NONE;
        }
        if (CompressionType.GZIP.name.equals(name)) {
            return GZIP;
        }
        if (CompressionType.SNAPPY.name.equals(name)) {
            return SNAPPY;
        }
        if (CompressionType.LZ4.name.equals(name)) {
            return LZ4;
        }
        if (CompressionType.ZSTD.name.equals(name)) {
            return ZSTD;
        }
        throw new IllegalArgumentException("Unknown compression name: " + name);
    }

    public int defaultLevel() {
        throw new UnsupportedOperationException("Compression levels are not defined for this compression type: " + this.name);
    }

    public int maxLevel() {
        throw new UnsupportedOperationException("Compression levels are not defined for this compression type: " + this.name);
    }

    public int minLevel() {
        throw new UnsupportedOperationException("Compression levels are not defined for this compression type: " + this.name);
    }

    public ConfigDef.Validator levelValidator() {
        throw new UnsupportedOperationException("Compression levels are not defined for this compression type: " + this.name);
    }

    public String toString() {
        return this.name;
    }
}

