/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.io.Serializable;
import java.util.Objects;
import org.openstreetmap.josm.data.osm.IRelationMember;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveData;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.tools.CheckParameterUtil;

public class RelationMemberData
implements IRelationMember<PrimitiveData>,
Serializable {
    private static final long serialVersionUID = 381392198209333319L;
    private final String role;
    private final long memberId;
    private final OsmPrimitiveType memberType;

    public RelationMemberData(String role, OsmPrimitiveType type, long id) {
        CheckParameterUtil.ensureParameterNotNull((Object)type, "type");
        this.role = (role == null ? "" : role).intern();
        this.memberType = type;
        this.memberId = id;
    }

    public RelationMemberData(String role, PrimitiveId primitive) {
        this(role, primitive.getType(), primitive.getUniqueId());
    }

    public long getMemberId() {
        return this.memberId;
    }

    @Override
    public String getRole() {
        return this.role;
    }

    public OsmPrimitiveType getMemberType() {
        return this.memberType;
    }

    @Override
    public OsmPrimitiveType getDisplayType() {
        return this.getMemberType();
    }

    @Override
    public boolean isNode() {
        return OsmPrimitiveType.NODE == this.memberType;
    }

    @Override
    public boolean isWay() {
        return OsmPrimitiveType.WAY == this.memberType;
    }

    @Override
    public boolean isRelation() {
        return OsmPrimitiveType.RELATION == this.memberType;
    }

    @Override
    public PrimitiveData getMember() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return (this.memberType != null ? this.memberType.getAPIName() : "undefined") + " " + this.memberId;
    }

    @Override
    public OsmPrimitiveType getType() {
        return this.getMemberType();
    }

    @Override
    public long getUniqueId() {
        return this.getMemberId();
    }

    @Override
    public boolean isNew() {
        return this.memberId <= 0L;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.role, this.memberId, this.memberType});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RelationMemberData that = (RelationMemberData)obj;
        return this.memberId == that.memberId && this.memberType == that.memberType && Objects.equals(this.role, that.role);
    }
}

